/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class Evaluate
extends SystemFunction {
    IndependentContext staticContext;
    InstructionDetails details;
    public static final int EVALUATE = 0;
    public static final int EXPRESSION = 1;
    public static final int EVAL = 2;
    public static final int EVALUATE_NODE = 3;

    protected SequenceType getRequiredType(int arg) {
        if (arg == 0) {
            return super.getRequiredType(arg);
        }
        return SequenceType.ANY_SEQUENCE;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        visitor.getExecutable().setReasonUnableToCompile("Cannot compile a stylesheet containing calls to saxon:evaluate");
        if (this.staticContext == null) {
            StaticContext env = visitor.getStaticContext();
            super.checkArguments(visitor);
            if (this.operation == 0 || this.operation == 1) {
                NamespaceResolver nsContext = env.getNamespaceResolver();
                this.staticContext = new IndependentContext(env.getConfiguration());
                this.staticContext.setBaseURI(env.getBaseURI());
                this.staticContext.setImportedSchemaNamespaces(env.getImportedSchemaNamespaces());
                this.staticContext.setDefaultFunctionNamespace(env.getDefaultFunctionNamespace());
                this.staticContext.setDefaultElementNamespace(env.getDefaultElementNamespace());
                Iterator iter = nsContext.iteratePrefixes();
                while (iter.hasNext()) {
                    String prefix = (String)iter.next();
                    if ("".equals(prefix)) continue;
                    String uri = nsContext.getURIForPrefix(prefix, true);
                    this.staticContext.declareNamespace(prefix, uri);
                }
                this.details = new InstructionDetails();
                this.details.setConstructType(2051);
                this.details.setSystemId(env.getLocationMap().getSystemId(this.locationId));
                this.details.setLineNumber(env.getLocationMap().getLineNumber(this.locationId));
            } else if (this.operation == 3) {
                this.staticContext = new IndependentContext(env.getConfiguration());
            }
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.operation == 1 && this.argument[0] instanceof StringLiteral) {
            try {
                PreparedExpression pexpr = new PreparedExpression();
                String exprText = ((StringLiteral)this.argument[0]).getStringValue();
                pexpr.variables = new XPathVariable[10];
                for (int i = 1; i < 10; ++i) {
                    pexpr.variables[i - 1] = this.staticContext.declareVariable("", "p" + i);
                }
                Expression expr = ExpressionTool.make(exprText, this.staticContext, 0, 0, 1, false);
                ItemType contextItemType = Type.ITEM_TYPE;
                expr = visitor.typeCheck(expr, contextItemType);
                pexpr.stackFrameMap = this.staticContext.getStackFrameMap();
                ExpressionTool.allocateSlots(expr, pexpr.stackFrameMap.getNumberOfVariables(), pexpr.stackFrameMap);
                pexpr.expression = expr;
                return new Literal(new ObjectValue(pexpr));
            }
            catch (XPathException err) {
                return this;
            }
        }
        return this;
    }

    private PreparedExpression prepareExpression(XPathContext context) throws XPathException {
        Expression expr;
        if (this.operation == 2) {
            Item item = this.argument[0].evaluateItem(context);
            if (!(item instanceof ObjectValue)) {
                this.dynamicError("First argument to saxon:eval must be an expression prepared using saxon:expression", "SXXF0001", context);
                return null;
            }
            ObjectValue obj = (ObjectValue)item;
            Object v = obj.getObject();
            if (!(v instanceof PreparedExpression)) {
                this.dynamicError("First argument to saxon:eval must be an expression prepared using saxon:expression", "SXXF0001", context);
                return null;
            }
            return (PreparedExpression)v;
        }
        PreparedExpression pexpr = new PreparedExpression();
        if (this.operation == 3) {
            Expression expr2;
            IndependentContext env;
            NodeInfo node = (NodeInfo)this.argument[0].evaluateItem(context);
            pexpr.expStaticContext = env = this.staticContext.copy();
            env.setBaseURI(node.getBaseURI());
            env.setFunctionLibrary(this.getExecutable().getFunctionLibrary());
            env.setNamespaces(node);
            String exprText = node.getStringValue();
            UnfailingIterator single = SingletonIterator.makeIterator(node);
            single.next();
            context.setCurrentIterator(single);
            try {
                expr2 = ExpressionTool.make(exprText, env, 0, 0, 1, false);
                expr2.setContainer(env);
            }
            catch (XPathException e) {
                String name = this.getFunctionName().getDisplayName();
                XPathException err = new XPathException("Static error in XPath expression supplied to " + name + ": " + e.getMessage().trim());
                err.setXPathContext(context);
                throw err;
            }
            ItemType contextItemType = Type.ITEM_TYPE;
            ExpressionVisitor visitor = ExpressionVisitor.make(env);
            visitor.setExecutable(env.getExecutable());
            expr2 = visitor.typeCheck(expr2, contextItemType);
            pexpr.stackFrameMap = env.getStackFrameMap();
            ExpressionTool.allocateSlots(expr2, pexpr.stackFrameMap.getNumberOfVariables(), pexpr.stackFrameMap);
            pexpr.expression = expr2;
            expr2.setContainer(env);
            return pexpr;
        }
        AtomicValue exprSource = (AtomicValue)this.argument[0].evaluateItem(context);
        String exprText = exprSource.getStringValue();
        IndependentContext env = this.staticContext.copy();
        env.setFunctionLibrary(this.getExecutable().getFunctionLibrary());
        pexpr.expStaticContext = env;
        pexpr.variables = new XPathVariable[10];
        for (int i = 1; i < 10; ++i) {
            pexpr.variables[i - 1] = env.declareVariable("", "p" + i);
        }
        try {
            expr = ExpressionTool.make(exprText, env, 0, 0, 1, false);
        }
        catch (XPathException e) {
            String name = this.getFunctionName().getDisplayName();
            XPathException err = new XPathException("Static error in XPath expression supplied to " + name + ": " + e.getMessage().trim());
            err.setXPathContext(context);
            throw err;
        }
        ItemType contextItemType = Type.ITEM_TYPE;
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        visitor.setExecutable(env.getExecutable());
        expr = visitor.typeCheck(expr, contextItemType);
        pexpr.stackFrameMap = env.getStackFrameMap();
        ExpressionTool.allocateSlots(expr, pexpr.stackFrameMap.getNumberOfVariables(), pexpr.stackFrameMap);
        pexpr.expression = expr;
        expr.setContainer(env);
        return pexpr;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        if (this.operation == 1) {
            PreparedExpression pexpr = this.prepareExpression(c);
            return new ObjectValue(pexpr);
        }
        if (this.operation == 3) {
            XPathContextMajor c2 = c.newCleanContext();
            PreparedExpression pexpr = this.prepareExpression(c2);
            c2.setOrigin(this.details);
            c2.openStackFrame(pexpr.stackFrameMap);
            return pexpr.expression.evaluateItem(c2);
        }
        XPathContextMajor c2 = c.newCleanContext();
        PreparedExpression pexpr = this.prepareExpression(c2);
        for (int i = 1; i < this.argument.length; ++i) {
            int slot = pexpr.variables[i - 1].getLocalSlotNumber();
            c2.setLocalVariable(slot, ExpressionTool.eagerEvaluate(this.argument[i], c));
        }
        c2.setOrigin(this.details);
        c2.openStackFrame(pexpr.stackFrameMap);
        c2.setCurrentIterator(c.getCurrentIterator());
        return pexpr.expression.evaluateItem(c2);
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        PreparedExpression pexpr = this.prepareExpression(c);
        if (this.operation == 1) {
            return SingletonIterator.makeIterator(new ObjectValue(pexpr));
        }
        XPathContextMajor c2 = c.newCleanContext();
        c2.setOrigin(this.details);
        c2.openStackFrame(pexpr.stackFrameMap);
        c2.setCurrentIterator(c.getCurrentIterator());
        for (int i = 1; i < this.argument.length; ++i) {
            int slot = pexpr.variables[i - 1].getLocalSlotNumber();
            c2.setLocalVariable(slot, ExpressionTool.eagerEvaluate(this.argument[i], c));
        }
        return Value.getIterator(ExpressionTool.lazyEvaluate(pexpr.expression, c2, 1));
    }

    public int getIntrinsicDependencies() {
        return 30;
    }

    public static class PreparedExpression
    implements Serializable {
        public IndependentContext expStaticContext;
        public Expression expression;
        public XPathVariable[] variables;
        public SlotManager stackFrameMap;
    }
}

